% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Individuals.R
\docType{class}
\name{Individuals-class}
\alias{Individuals-class}
\title{Class Individuals}
\description{
\code{Individuals} Class consists of spatio-temporal parameters about exposed populations.

Individual gets coordinates (as SpatialPoints), a date of birth, a life duration, an intern toxic concentration over the time and a toxic threshold (max value of toxic before death).

Each individual in an Individuals object is identified by an ID which is used as index to access attributes in the object.
}
\details{
Objects can be created by calling of the allocator new("Individuals", ...), or (preferred) by calling one of the wrapped functions \link{simulateIndividuals} or \link{loadIndividuals}.
}
\section{Slots}{

\describe{
\item{\code{n}}{individuals Number}

\item{\code{coordinate}}{individuals coordinates (as SpatialPoints)}

\item{\code{xmin}}{x-axis left value}

\item{\code{xmax}}{x-axis right value}

\item{\code{ymin}}{y-axis bottom value}

\item{\code{ymax}}{y-axis top value}

\item{\code{dob}}{Date of birth (as vector)}

\item{\code{life_duration}}{individuals life duration (as vector)}

\item{\code{intern_toxic}}{individuals intern toxic concentration in time (as matrix)}

\item{\code{toxic_threshold}}{individuals max toxic concentration leading to death (as vector)}

\item{\code{mintime}}{Start simulation time}

\item{\code{maxtime}}{End simulation time}
}}
\seealso{
\code{\link{simulateIndividuals}} , \code{\link{loadIndividuals}}
}

