% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semUtils.R
\name{orientEdges}
\alias{orientEdges}
\title{Assign edge orientation of an undirected graph}
\usage{
orientEdges(ug, dg, ...)
}
\arguments{
\item{ug}{An undirected graph as an igraph object.}

\item{dg}{A directed reference graph.}

\item{...}{Currently ignored.}
}
\value{
A directed graph as an igraph object.
}
\description{
Assign edge orientation of an undirected graph
through a given reference directed graph. The vertex (color)
and edge (color, width and weight) attributes of the input
undirected graph are preserved in the output directed graph.
}
\examples{

# Graphs definition
G0 <- as.undirected(sachs$graph)

# Reference graph-based orientation
G1 <- orientEdges(ug = G0, dg = sachs$graph)

# Graphs plotting
old.par <- par(no.readonly = TRUE)
par(mfrow=c(1,2), mar=rep(2,4))
plot(G0, layout=layout.circle, main = "Input undirected graph")
plot(G1, layout=layout.circle, main = "Output directed graph")
par(old.par)

}
