% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootspat_str.R
\name{bootspat_str}
\alias{bootspat_str}
\title{Spatially structured sample}
\usage{
bootspat_str(
  x,
  rprob = NULL,
  rich = NULL,
  fr_prob = NULL,
  cores = 1,
  filename = "",
  memory = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{x}{SpatRaster. A presence-absence SpatRaster.}

\item{rprob}{SpatRaster. Stack of probability values. Structures the spatial
pattern of each randomized species.}

\item{rich}{SpatRaster. Richness pattern structuring the sample size of
each cell randomization. Calculated if not provided.}

\item{fr_prob}{Either frequency of pixels or probability that a species is
observed across the whole layer.}

\item{cores}{positive integer. If \code{cores > 1}, a 'parallel' package cluster with that many cores is created and used. You can also supply a cluster object. Ignored for functions that are implemented by terra in C++ (see under fun)}

\item{filename}{character. Output filename}

\item{memory}{logical. Checks if there is enough available RAM memory. Calculated if NULL}

\item{overwrite}{logical. If \code{TRUE}, \code{filename} is overwritten}

\item{...}{additional parameters for terra::app}
}
\value{
SpatRaster object
}
\description{
Randomizes a raster stack with fixed richness.
Randomizations are based on frequencies (given or calculated from x)
and, optionally, a probability raster stack.
Both, frequencies and probability raster stack, control the probability that a
given species is sampled in each cell raster. Frequency controls the probability
of each species being sampled compared to all others. Probability raster stack
controls the probability that each species is sampled in a given raster cell.
}
\examples{
# load random species distributions
library(SESraster)
library(terra)
r <- load_ext_data()
plot(r)

# applying the function
rand.str <- bootspat_str(r)
plot(rand.str)

# With null probability raster
rprobnull <- terra::app(r,
                       function(x){
                       ifelse(is.na(x), NA, 1)
                       })
rand.str2 <- bootspat_str(r, rprob = rprobnull)


library(SESraster)
library(terra)
# creating random species distributions
f <- system.file("ex/elev.tif", package="terra")
r <- rast(f)
set.seed(510)
r10 <- rast(lapply(1:18,
                function(i, r, mn, mx){
                  app(r, function(x, t){
                    sapply(x, function(x, t){
                       x<max(t) & x>min(t)
                    }, t=t)
                  }, t=sample(seq(mn, mx), 2))
                }, r=r, mn=minmax(r)[1]+10, mx=minmax(r)[2]-10))

names(r10) <- paste("sp", 1:nlyr(r10))
plot(r10)

rprobnull <- terra::app(r10,
                       function(x){
                       ifelse(is.na(x), NA, 1)
                       })

# bootstrapping once
randr10 <- bootspat_str(r10, rprobnull)
plot(randr10)
plot(c(sum(r10), sum(randr10)), main=c("observed", "randomized"))
cbind(observed=sapply(r10, function(x)freq(x)[2,3]),
      randomized=sapply(randr10, function(x)freq(x)[2,3]))

}
\seealso{
\code{\link{bootspat_naive}}
}
\author{
Neander Marcel Heming
}
