% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xylookup.R
\name{lookup_xy}
\alias{lookup_xy}
\title{Lookup spatial information for geographic points}
\usage{
lookup_xy(
  data = NULL,
  lon = NULL,
  lat = NULL,
  shoredistance = TRUE,
  grids = TRUE,
  areas = FALSE,
  as_data_frame = TRUE
)
}
\arguments{
\item{data}{Optional data frame containing coordinate columns. The expected names are
\code{sample_longitude_dd} and \code{sample_latitude_dd}. These must be numeric and fall
within valid geographic ranges.}

\item{lon}{Optional numeric vector of longitudes. Must be supplied together with \code{lat}
when used. Ignored when a data frame is provided unless both \code{lon} and \code{lat} are set.}

\item{lat}{Optional numeric vector of latitudes. Must be supplied together with \code{lon}
when used.}

\item{shoredistance}{Logical; if \code{TRUE}, distance to the nearest shore is included.}

\item{grids}{Logical; if \code{TRUE}, environmental grid values are included.}

\item{areas}{Logical or numeric. When logical, \code{TRUE} requests area values at zero radius,
and \code{FALSE} disables area retrieval. A positive integer specifies the search radius
in meters for area values.}

\item{as_data_frame}{Logical; if \code{TRUE}, the result is returned as a data frame.
When \code{FALSE}, the result is returned as a list.}
}
\value{
A data frame or list, depending on \code{as_data_frame}. Invalid coordinates produce
\code{NA} entries (data frame) or \code{NULL} elements (list). Duplicate input coordinates
return repeated results.
}
\description{
Retrieves shore distance, environmental grids, and area values for given coordinates.
Coordinates may be supplied either through a data frame or as separate numeric vectors.
}
\details{
\itemize{
\item When both vector inputs and a data frame are provided, the vector inputs take precedence.
\item Coordinates are validated and cleaned before lookup, and only unique values are queried.
\item Queries are processed in batches to avoid overloading the remote service.
\item Area retrieval accepts either a logical flag or a radius. A radius of zero corresponds to
requesting a single area value.
\item Final results are reordered to match the original input positions.
\item The function has been modified from the \code{obistools} package (Provoost and Bosch, 2024).
}
}
\examples{
\donttest{
# Using a data frame
df <- data.frame(sample_longitude_dd = c(10.9, 18.3),
                 sample_latitude_dd = c(58.1, 58.3))
lookup_xy(df)

# Area search within a radius
lookup_xy(df, areas = 500)

# Using separate coordinate vectors
lookup_xy(lon = c(10.9, 18.3), lat = c(58.1, 58.3))
}

}
\references{
Provoost P, Bosch S (2024). “obistools: Tools for data enhancement and quality control” Ocean Biodiversity Information System. Intergovernmental Oceanographic Commission of UNESCO. R package version 0.1.0, \url{https://iobis.github.io/obistools/}.
}
\seealso{
\code{\link{check_onland}}, \code{\link{check_depth}}, \url{https://iobis.github.io/xylookup/} – OBIS xylookup web service
}
