% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{load_shark4r_fields}
\alias{load_shark4r_fields}
\title{Load SHARK4R fields from GitHub}
\usage{
load_shark4r_fields(verbose = TRUE)
}
\arguments{
\item{verbose}{Logical; if \code{TRUE} (default), prints progress messages during download and loading.}
}
\value{
Invisibly returns a list with two elements:
\describe{
\item{required_fields}{Object containing required SHARK fields.}
\item{recommended_fields}{Object containing recommended SHARK fields.}
}
}
\description{
This function downloads and sources the SHARK4R required and recommended field definitions
directly from the
\href{https://github.com/nodc-sweden/SHARK4R-statistics}{SHARK4R-statistics} GitHub repository.
}
\details{
The definitions are stored in an R script (\code{fields.R}) located in the \verb{fields/} folder of the repository.
The function sources this file directly from GitHub into the current R session.

The sourced script defines two main objects:
\itemize{
\item \code{required_fields} — vector or data frame of required SHARK fields.
\item \code{recommended_fields} — vector or data frame of recommended SHARK fields.
}

The output of this function can be directly supplied to the
\code{\link{check_fields}} function through its \code{field_definitions} argument
for validating SHARK4R data consistency.

If sourcing fails (e.g., due to a network issue or repository changes), the function throws
an error with a descriptive message.
}
\examples{
\donttest{
# Load SHARK4R field definitions from GitHub
fields <- load_shark4r_fields(verbose = FALSE)

# Access required or recommended fields for the first entry
fields[[1]]$required
fields[[1]]$recommended
}
\dontrun{
# Use the loaded definitions in check_fields()
check_fields(my_data, field_definitions = fields)
}

}
\seealso{
\code{\link{check_fields}} for validating datasets using the loaded field definitions (as \code{field_definitions}).
\code{\link{load_shark4r_stats}} for loading precomputed SHARK4R statistics,
}
