% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survivalScenario.R
\name{survivalScenario}
\alias{survivalScenario}
\title{Scenario Testing for Survival Extrapolation}
\usage{
survivalScenario(
  tLower = 0,
  tUpper,
  expLower,
  expUpper,
  tTarget,
  survDf,
  groups = levels(survDf$treatment),
  expGroup = levels(survDf$treatment)[1],
  xl = "Time",
  fontsize = 12,
  showPlot = TRUE
)
}
\arguments{
\item{tLower}{lower limit for x-axis.}

\item{tUpper}{upper limit for x-axis.}

\item{expLower}{start time at which constant hazard is assumed.}

\item{expUpper}{end time for using data to estimate constant hazard;
data after this time will be censored.}

\item{tTarget}{target extrapolation time.}

\item{survDf}{data frame with individual patient data. Require to bea .csv file with
three columns: "time", "event" and "treatment" (in that order).
Values in the "event" column should be 0 for a censored observation, and 1 otherwise.
The"treatment" column should be included even if there is only one treatment group.'}

\item{groups}{character vector of names of the treatment group. Extracted from survDF by default.}

\item{expGroup}{selected treatment group for extrapolating}

\item{xl}{x-axis label}

\item{fontsize}{plot fontsize}

\item{showPlot}{whether to display the plot}
}
\value{
A list containing the elements
\item{KMplot}{a ggplot2 plot object;}
\item{interval}{an approximate 95% credible interval for the survival proportion
at the target extrapolation time.}
}
\description{
Provides a plot and approximate 95% credible interval for an 
extrapolated surival time, based on a assumption of constant hazard 
after some specified time. Intended to be used as part of the SHELF protocol
for elicitation for survival extrapolation.
}
\examples{
\dontrun{
sdf <- survival::veteran[, c("time", "status", "trt")]
colnames(sdf) <- c("time", "event", "treatment")
sdf$treatment <- factor(sdf$treatment, labels = c("standard", "test"))
survivalScenario(tLower = 0,tUpper = 150, expLower = 100, expUpper = 150,
tTarget = 250, survDf = sdf,
expGroup = "standard")
}
}
