% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSurvivalTable.R
\name{makeSurvivalTable}
\alias{makeSurvivalTable}
\title{Tabulate Summary Data for Survival Extrapolation}
\usage{
makeSurvivalTable(
  survDf,
  breakTime,
  truncationTime,
  timeUnit,
  useWeights = FALSE,
  dp = 2
)
}
\arguments{
\item{survDf}{data frame with individual patient data. Needs three columns with names
"time", "event" and "treatment" (in that order). For weighted observations (e.g. 
using propensity scores), include a fourth column "weights".
Values in the "event" column should be 0 for a censored observation, and 1 otherwise.
The "treatment" column should be included even if there is only one treatment group.}

\item{breakTime}{duration of each time interval}

\item{truncationTime}{time point for the end of the last interval}

\item{timeUnit}{string variable to give unit of time}

\item{useWeights}{set to TRUE if survDf includes column of weights, as described in specification 
of survDf. This column is passed on to survival::survfit() as the case weights.}

\item{dp}{number of decimal places to display}
}
\value{
a data frame with survivor function estimates, 95% confidence intervals,
and within interval hazard estimates for each time interval.
}
\description{
Tabulates the Kaplan Meier survivor function and within interval hazard at discrete equally spaced time points t_1,...,t_n
"Within interval hazard" is defined as (1-S(t_[n+1])) / S_(t_n), using the Kaplan Meier estimate of S().
The table is intended to be included on a summary sheet provided to experts when eliciting judgements about
extrapolated survival probabilities.
}
\examples{
\dontrun{
sdf <- survival::veteran[, c("time", "status", "trt")]
colnames(sdf) <- c("time", "event", "treatment")
sdf$treatment <- factor(sdf$treatment, labels = c("standard", "test"))
makeSurvivalTable(sdf, breakTime = 50, truncationTime = 250, timeUnit = "months")
}
}
