% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L1_Pop.R
\name{combineBeeGametesHaploDiploid}
\alias{combineBeeGametesHaploDiploid}
\title{Create diploid gametes from a mated queen}
\usage{
combineBeeGametesHaploDiploid(queen, drones, nProgeny = 1, simParamBee = NULL)
}
\arguments{
\item{queen}{\code{\link{Pop-class}}, with a single diploid individual}

\item{drones}{\code{\link{Pop-class}}, with one or more haploid individual(s)}

\item{nProgeny}{integer, number of progeny to create per cross}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}
}
\value{
\code{\link{Pop-class}} with diploid individuals
}
\description{
Level 1 function that produces diploid offspring from a mated queen.
  Drones are haploid, while the queen is diploid, so we first generate gametes
  (with recombination) from her and merge them with drone genomes (=gametes),
  where we randomly re-sample drones to get the desired number of progeny.
  This is an utility function, and you most likely want to use the
  \code{\link{cross}} function.
}
\details{
This would be the right approach to handle haplo-diploid inheritance
  in bees, but it causes a raft of downstream issues, since AlphaSimR assumes
  that individuals have the same ploidy. Hence, we don't use this function.
}
