% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{createRandomCrossPlan}
\alias{createRandomCrossPlan}
\title{Create a cross plan by randomly sampling drones for each queen
  from a drone population}
\usage{
createRandomCrossPlan(IDs, drones, nDrones)
}
\arguments{
\item{IDs}{numeric, IDs of either the virgin queens OR the colonies (can't have both
in the same cross plan!)}

\item{drones}{\code{\link{Pop-class}}, drone population available for mating (DCA)}

\item{nDrones}{integer or function, number of drones to be mated with each virgin
queen}
}
\value{
named list with names being virgin queen or colony input IDs with each
  list element holding the IDs of selected drones
}
\description{
Level 0 function that creates a cross plan by randomly sampling
  a desired number of drones from a DCA and assigning them to either
  virgin queen or colony ID
}
\examples{
founderGenomes <- quickHaplo(nInd = 15, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(basePop[1], n = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = 10)

# Create an apiary of colonies and cross it
apiary <- createMultiColony(x = basePop[2:5])
apiary <- cross(apiary, drones = droneGroups[1:4])
apiary <- buildUp(apiary, nWorkers = 100, nDrones = 100)

# Create a DCA from the drones from the apiary
DCA <- createDCA(apiary)
DCA # Inspect the DCA

# Create virgin queens, a virgin colony, and a virgin apiary
virginQueen1 <- basePop[6]
virginQueen2 <- basePop[7]
colony1 <- createColony(basePop[8])
apiary1 <- createMultiColony(basePop[9:11])

# Create a combined cross plan for mating the virgin queens (with virgin queen IDs)
crossPlanVirginQueens <- createRandomCrossPlan(IDs = c(virginQueen1@id, virginQueen2@id),
                                               drones = DCA,
                                               nDrones = nFathersPoisson)

# Cross the virgin queens according to the cross plan
virginQueen1 <- cross(virginQueen1, drones = DCA, crossPlan = crossPlanVirginQueens)
virginQueen2 <- cross(virginQueen2, drones = DCA, crossPlan = crossPlanVirginQueens)

# Create a cross plan for mating the virgin colonies and the virgin apiary (with colony IDs)
crossPlanColonies <- createRandomCrossPlan(IDs = getId(c(colony1, apiary1)),
                                           drones = DCA,
                                           nDrones = nFathersPoisson)

# Cross the colonies according to the cross plan
colony1 <- cross(colony1, drones = DCA, crossPlan = crossPlanColonies)
apiary1 <- cross(apiary1, drones = DCA, crossPlan = crossPlanColonies)
nFathers(colony1)
nFathers(apiary1)

# You can mate virgin queens and colonies in the same way on the mating stations's DCA
# Create a mating station from colony1
matingStationDCA <- createMatingStationDCA(colony1, nDPQs = 20, nDronePerDPQ = 10)

# Create another virgin apiary
apiary2 <- createMultiColony(basePop[12:14])

# Create a cross plan with colonyIDs for crossing the apiary on the mating station
crossPlanApiary <- createRandomCrossPlan(IDs = getId(apiary2),
                                         drones = matingStationDCA,
                                         nDrones = nFathersPoisson)

# Cross the apiary
apiary2 <- cross(apiary2, drones = matingStationDCA, crossPlan = crossPlanApiary)
nFathers(apiary2)

}
