% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L2_Colony.R
\name{supersede}
\alias{supersede}
\title{Supersede}
\usage{
supersede(x, year = NULL, nVirginQueens = NULL, simParamBee = NULL, ...)
}
\arguments{
\item{x}{\code{\link{Colony-class}} or \code{\link{MultiColony-class}}}

\item{year}{numeric, year of birth for virgin queens}

\item{nVirginQueens}{integer, the number of virgin queens to be created in the
colony; of these one is randomly selected as the new virgin queen of the
remnant colony. If \code{NULL}, the value from \code{simParamBee$nVirginQueens}
is used}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}

\item{...}{additional arguments passed to \code{nVirginQueens} when this
argument is a function}
}
\value{
\code{\link{Colony-class}} or \code{\link{MultiColony-class}} with the
supersede event set to \code{TRUE}
}
\description{
Level 2 function that supersedes a Colony or MultiColony object -
  an event where the
  queen dies. The workers and drones stay unchanged, but workers raise virgin
  queens, of which only one prevails.
}
\examples{
founderGenomes <- quickHaplo(nInd = 10, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(basePop[1], n = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = 10)

# Create Colony and MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
(colony <- buildUp(colony, nWorkers = 100))
apiary <- createMultiColony(basePop[3:8], n = 6)
apiary <- cross(apiary, drones = droneGroups[2:7])
apiary <- buildUp(apiary, nWorkers = 100)

# Supersede a colony
isQueenPresent(colony)
isVirginQueensPresent(colony)
colony <- supersede(colony)
isQueenPresent(colony)
isVirginQueensPresent(colony)

# Supersede all colonies in the apiary
isQueenPresent(colony)
isVirginQueensPresent(colony)
apiary1 <- supersede(apiary)
isQueenPresent(colony)
isVirginQueensPresent(colony)

# Sample colonies from the apiary that will supersede (sample with probability of 0.2)
tmp <- pullColonies(apiary, p = 0.2)
# Swarm only the pulled colonies
(supersede(tmp$pulled))
}
