% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIR_threshold.R
\name{SIR_threshold}
\alias{SIR_threshold}
\title{SIR threshold}
\usage{
SIR_threshold(
  Y,
  X,
  H = 10,
  lambda = 0,
  thresholding = "hard",
  graph = TRUE,
  choice = ""
)
}
\arguments{
\item{Y}{A numeric vector representing the dependent variable (a response vector).}

\item{X}{A matrix representing the quantitative explanatory variables (bind by column).}

\item{H}{The chosen number of slices (default is 10).}

\item{lambda}{The thresholding parameter (default is 0).}

\item{thresholding}{The thresholding method to choose between hard and soft (default is hard).}

\item{graph}{A boolean that must be set to true to display graphics (default is TRUE).}

\item{choice}{the graph to plot: 
\itemize{
  \item "eigvals" Plot the eigen values of the matrix of interest.
  \item "estim_ind" Plot the estimated index by the SIR model versus Y.
  \item "" Plot every graphs (default).
}}
}
\value{
An object of class SIR_threshold, with attributes:
\item{b}{This is an estimated EDR direction, which is the principal eigenvector 
of the interest matrix.}
\item{M1}{The interest matrix thresholded.}
\item{eig_val}{The eigenvalues of the interest matrix thresholded.}
\item{eig_vect}{A matrix corresponding to the eigenvectors of the interest matrix.}
\item{Y}{The response vector.}
\item{n}{Sample size.}
\item{p}{The number of variables in X.}
\item{H}{The chosen number of slices.}
\item{nb.zeros}{The number of 0 in the estimation of the vector beta.}
\item{index_pred}{The index Xb' estimated by SIR.}
\item{list.relevant.variables}{A list that contains the variables selected by the
model.}
\item{cos_squared}{The cosine squared between vanilla SIR and SIR thresholded.}
\item{lambda}{The thresholding parameter used.}
\item{thresholding}{The thresholding method used.}
\item{call}{Unevaluated call to the function.}
\item{X_reduced}{The X data restricted to the variables selected by the model.
It can be used to estimate a new SIR model on the relevant variables to improve
the estimation of b.}
}
\description{
Apply a single-index \eqn{SIR} on \eqn{(X,Y)} with \eqn{H} slices, with a parameter \eqn{\lambda} which 
apply a soft/hard thresholding to the interest matrix \eqn{\widehat{\Sigma}_n^{-1}\widehat{\Gamma}_n}.
}
\examples{
# Generate Data
set.seed(10)
n <- 500
beta <- c(1,1,rep(0,8))
X <- mvtnorm::rmvnorm(n,sigma=diag(1,10))
eps <- rnorm(n)
Y <- (X\%*\%beta)**3+eps

# Apply SIR with hard thresholding
SIR_threshold(Y, X, H = 10, lambda = 0.2, thresholding = "hard")
}
