% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLICER.R
\name{assign_branches}
\alias{assign_branches}
\title{Detect branches in the trajectory and assign cells to branches}
\usage{
assign_branches(traj_graph, start, min_branch_len = 10,
  cells = V(traj_graph))
}
\arguments{
\item{traj_graph}{Nearest neighbor graph built from LLE embedding}

\item{start}{Index of start cell}

\item{min_branch_len}{Minimum number of cells required to call a branch}

\item{cells}{List of indices indicating which cells to assign
to branches (used for recursive calls; not intended to be set
by users).}
}
\value{
Vector of integers assigning each cell to a branch
}
\description{
This function uses geodesic entropy to automatically determine
the number and location of branches in the trajectory.
Each cell is then assigned to the corresponding branch.
}
\examples{
\dontrun{
traj_lle = lle::lle(traj[,genes],m=2,k)$Y
traj_graph = conn_knn_graph(traj_lle,5)
start=1
branches = assign_branches(traj_graph,start)
plot(traj_lle,pch=16,col=branches)
}
}
