% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLICER.R
\name{conn_knn_graph}
\alias{conn_knn_graph}
\title{Construct a k-nearest neighbor graph that is fully connected}
\usage{
conn_knn_graph(embedding, k)
}
\arguments{
\item{embedding}{Low-dimensional LLE embedding of cells}

\item{k}{Number of nearest neighbors}
}
\value{
An igraph object corresponding to the k-NN graph
}
\description{
This function constructs a k-nearest neighbor graph using an
LLE embedding, then adds the minimum number of edges needed to
make the graph fully connected.
}
\examples{
genes=1:200
cells=sample(1:500,30)
k=10
traj_lle = lle::lle(traj[cells,genes],m=2,k)$Y
traj_graph = conn_knn_graph(traj_lle,5)
}
