% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/S3_FalsePositiveRate.R
\name{fpr.factor}
\alias{fpr.factor}
\alias{weighted.fpr.factor}
\alias{fpr.cmatrix}
\alias{fallout.factor}
\alias{weighted.fallout.factor}
\alias{fallout.cmatrix}
\alias{fpr}
\alias{fallout}
\alias{weighted.fpr}
\alias{weighted.fallout}
\title{False Positive Rate}
\usage{
\method{fpr}{factor}(actual, predicted, micro = NULL, na.rm = TRUE, ...)

\method{weighted.fpr}{factor}(actual, predicted, w, micro = NULL, na.rm = TRUE, ...)

\method{fpr}{cmatrix}(x, micro = NULL, na.rm = TRUE, ...)

\method{fallout}{factor}(actual, predicted, micro = NULL, na.rm = TRUE, ...)

\method{weighted.fallout}{factor}(actual, predicted, w, micro = NULL, na.rm = TRUE, ...)

\method{fallout}{cmatrix}(x, micro = NULL, na.rm = TRUE, ...)

## Generic S3 method
fpr(
 ...,
 micro = NULL,
 na.rm = TRUE
)

## Generic S3 method
fallout(
 ...,
 micro = NULL,
 na.rm = TRUE
)

## Generic S3 method
weighted.fpr(
 ...,
 w,
 micro = NULL,
 na.rm = TRUE
)

## Generic S3 method
weighted.fallout(
 ...,
 w,
 micro = NULL,
 na.rm = TRUE
)
}
\arguments{
\item{actual}{A vector of <\link{factor}> values of \link{length} \eqn{n}, and \eqn{k} levels.}

\item{predicted}{A vector of <\link{factor}> values of \link{length} \eqn{n}, and \eqn{k} levels.}

\item{micro}{A <\link{logical}>-value of \link{length} \eqn{1} (default: \link{NULL}). If \link{TRUE} it returns the
micro average across all \eqn{k} classes, if \link{FALSE} it returns the macro average.}

\item{na.rm}{A <\link{logical}> value of \link{length} \eqn{1} (default: \link{TRUE}). If \link{TRUE}, \link{NA} values are removed from the computation.
This argument is only relevant when \code{micro != NULL}.
When \code{na.rm = TRUE}, the computation corresponds to \code{sum(c(1, 2, NA), na.rm = TRUE) / length(na.omit(c(1, 2, NA)))}.
When \code{na.rm = FALSE}, the computation corresponds to \code{sum(c(1, 2, NA), na.rm = TRUE) / length(c(1, 2, NA))}.}

\item{...}{Arguments passed into other methods}

\item{w}{A <\link{numeric}>-vector of \link{length} \eqn{n}. \link{NULL} by default.}

\item{x}{A confusion matrix created \code{\link[=cmatrix]{cmatrix()}}.}
}
\value{
If \code{micro} is \link{NULL} (the default), a named <\link{numeric}>-vector of \link{length} k

If \code{micro} is \link{TRUE} or \link{FALSE}, a <\link{numeric}>-vector of \link{length} 1
}
\description{
A generic function for the \href{https://en.wikipedia.org/wiki/False_positive_rate}{False Positive Rate}. Use \code{\link[=weighted.fpr]{weighted.fpr()}} for the weighted \href{https://en.wikipedia.org/wiki/False_positive_rate}{False Positive Rate}.
\subsection{Other names}{

Fallout
}
}
\section{Definition}{

Let \eqn{\hat{\gamma} \in [0, 1]} be the proportion of false positives among the actual negatives. The false positive rate of the classifier is calculated as,

\deqn{
  \hat{\gamma} = \frac{\#FP_k}{\#TN_k + \#FP_k}
}

Where:
\itemize{
\item \eqn{\#TN_k} is the number of true negatives, and
\item \eqn{\#FP_k} is the number of false positives.
}
}

\section{Creating <\link{factor}>}{


Consider a classification problem with three classes: \code{A}, \code{B}, and \code{C}. The actual vector of \code{\link[=factor]{factor()}} values is defined as follows:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{## set seed
set.seed(1903)

## actual
factor(
  x = sample(x = 1:3, size = 10, replace = TRUE),
  levels = c(1, 2, 3),
  labels = c("A", "B", "C")
)
#>  [1] B A B B A C B C C A
#> Levels: A B C
}\if{html}{\out{</div>}}

Here, the values 1, 2, and 3 are mapped to \code{A}, \code{B}, and \code{C}, respectively. Now, suppose your model does not predict any \code{B}'s. The predicted vector of \code{\link[=factor]{factor()}} values would be defined as follows:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{## set seed
set.seed(1903)

## predicted
factor(
  x = sample(x = c(1, 3), size = 10, replace = TRUE),
  levels = c(1, 2, 3),
  labels = c("A", "B", "C")
)
#>  [1] C A C C C C C C A C
#> Levels: A B C
}\if{html}{\out{</div>}}

In both cases, \eqn{k = 3}, determined indirectly by the \code{levels} argument.
}

\examples{
# 1) recode Iris
# to binary classification
# problem
iris$species_num <- as.numeric(
  iris$Species == "virginica"
)

# 2) fit the logistic
# regression
model <- glm(
  formula = species_num ~ Sepal.Length + Sepal.Width,
  data    = iris,
  family  = binomial(
    link = "logit"
  )
)

# 3) generate predicted
# classes
predicted <- factor(
  as.numeric(
    predict(model, type = "response") > 0.5
  ),
  levels = c(1,0),
  labels = c("Virginica", "Others")
)

# 3.1) generate actual
# classes
actual <- factor(
  x = iris$species_num,
  levels = c(1,0),
  labels = c("Virginica", "Others")
)

# 4) evaluate class-wise performance
# using False Positive Rate

# 4.1) unweighted False Positive Rate
fpr(
  actual    = actual,
  predicted = predicted
)

# 4.2) weighted False Positive Rate
weighted.fpr(
  actual    = actual,
  predicted = predicted,
  w         = iris$Petal.Length/mean(iris$Petal.Length)
)

# 5) evaluate overall performance
# using micro-averaged False Positive Rate
cat(
  "Micro-averaged False Positive Rate", fpr(
    actual    = actual,
    predicted = predicted,
    micro     = TRUE
  ),
  "Micro-averaged False Positive Rate (weighted)", weighted.fpr(
    actual    = actual,
    predicted = predicted,
    w         = iris$Petal.Length/mean(iris$Petal.Length),
    micro     = TRUE
  ),
  sep = "\n"
)
}
\seealso{
Other Classification: 
\code{\link{ROC.factor}()},
\code{\link{accuracy.factor}()},
\code{\link{baccuracy.factor}()},
\code{\link{ckappa.factor}()},
\code{\link{cmatrix.factor}()},
\code{\link{dor.factor}()},
\code{\link{entropy.matrix}()},
\code{\link{fbeta.factor}()},
\code{\link{fdr.factor}()},
\code{\link{fer.factor}()},
\code{\link{fmi.factor}()},
\code{\link{jaccard.factor}()},
\code{\link{logloss.factor}()},
\code{\link{mcc.factor}()},
\code{\link{nlr.factor}()},
\code{\link{npv.factor}()},
\code{\link{plr.factor}()},
\code{\link{pr.auc.matrix}()},
\code{\link{prROC.factor}()},
\code{\link{precision.factor}()},
\code{\link{recall.factor}()},
\code{\link{roc.auc.matrix}()},
\code{\link{specificity.factor}()},
\code{\link{zerooneloss.factor}()}

Other Supervised Learning: 
\code{\link{ROC.factor}()},
\code{\link{accuracy.factor}()},
\code{\link{baccuracy.factor}()},
\code{\link{ccc.numeric}()},
\code{\link{ckappa.factor}()},
\code{\link{cmatrix.factor}()},
\code{\link{dor.factor}()},
\code{\link{entropy.matrix}()},
\code{\link{fbeta.factor}()},
\code{\link{fdr.factor}()},
\code{\link{fer.factor}()},
\code{\link{huberloss.numeric}()},
\code{\link{jaccard.factor}()},
\code{\link{logloss.factor}()},
\code{\link{mae.numeric}()},
\code{\link{mape.numeric}()},
\code{\link{mcc.factor}()},
\code{\link{mpe.numeric}()},
\code{\link{mse.numeric}()},
\code{\link{nlr.factor}()},
\code{\link{npv.factor}()},
\code{\link{pinball.numeric}()},
\code{\link{plr.factor}()},
\code{\link{pr.auc.matrix}()},
\code{\link{prROC.factor}()},
\code{\link{precision.factor}()},
\code{\link{rae.numeric}()},
\code{\link{recall.factor}()},
\code{\link{rmse.numeric}()},
\code{\link{rmsle.numeric}()},
\code{\link{roc.auc.matrix}()},
\code{\link{rrmse.numeric}()},
\code{\link{rrse.numeric}()},
\code{\link{rsq.numeric}()},
\code{\link{smape.numeric}()},
\code{\link{specificity.factor}()},
\code{\link{zerooneloss.factor}()}
}
\concept{Classification}
\concept{Supervised Learning}
