% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SOHPIE_DNA.R
\name{SOHPIE_DNA}
\alias{SOHPIE_DNA}
\title{SOHPIE_DNA}
\usage{
SOHPIE_DNA(OTUdat, clindat, groupA, groupB)
}
\arguments{
\item{OTUdat}{An OTU table with subjects in rows and taxa in columns.}

\item{clindat}{A subdata consisting of the clinical and demographic variables that
the user wants to include in the regression.
(e.g., binary group indicator for intervention vs. control, continuous age, ...)}

\item{groupA}{Indices of the subjects in the first category (e.g., not living with a dog; see example below with American Gut Project sample data)
of binary group variable.}

\item{groupB}{Indices of the subjects in the second category (e.g., living with a dog; see example below with American Gut Project sample data)
of binary group variable.}
}
\value{
A list containing three data frame objects returned from this SOHPIE_DNA main function. A user will see
        beta coefficients, p-values, and adjusted p-values (q-values)
        for each predictor variables that are included in the regression model.
}
\description{
A pseudo-value regression approach for differential co-abundance
    network analysis that adjusts for additional covariates.
}
\examples{
\donttest{
# In this example, the subset of the American Gut Project data will be used.
data(combinedamgut) # A complete data containing columns with taxa and clinical covariates.

# Note: The line below will use a toy example with the first 30 out of 138 taxa.
OTUtab = combinedamgut[ , 8:37]
 #Clinical/demographic covariates (phenotypic data):
# Note: All of these covariates will be included in the regression, so
# please make sure that phenodat includes the variables that will be analyzed only.
phenodat = combinedamgut[, 1:7] # first column is ID, so not using it.
# Obtain indices of each grouping factor
# In this example, a variable indicating the status of living
# with a dog was chosen (i.e. bin_dog).
# Accordingly, Groups A and B imply living without and with a dog, respectively.
newindex_grpA = which(combinedamgut$bin_dog == 0)
newindex_grpB = which(combinedamgut$bin_dog == 1)

SOHPIEres <- SOHPIE_DNA(OTUdat = OTUtab, clindat = phenodat,
groupA = newindex_grpA, groupB = newindex_grpB)
}
}
\references{
Ahn S, Datta S. Differential Co-Abundance Network Analyses for Microbiome Data Adjusted for Clinical Covariates Using Jackknife Pseudo-Values.
     ArXiv [Preprint]. 2023 Mar 23:arXiv:2303.13702v1. PMID: 36994149; PMCID: PMC10055480.
}
