% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildRandomForest.R
\name{buildRandomForest}
\alias{buildRandomForest}
\title{Random Forest Interface}
\usage{
buildRandomForest(x, y, control = list())
}
\arguments{
\item{x}{matrix of input parameters. Rows for each point, columns for each parameter.}

\item{y}{one column matrix of observations to be modeled.}

\item{control}{list of control parameters, currently not used.}
}
\value{
an object of class \code{"spotRandomForest"}, with a \code{predict} method and a \code{print} method.
}
\description{
This is a simple wrapper for the randomForest function from the randomForest package.
The purpose of this function is to provide an interface as required by SPOT, to enable
modeling and model-based optimization with random forest.
}
\examples{
\dontrun{
## Test-function:
braninFunction <- function (x) {	
	(x[2]  - 5.1/(4 * pi^2) * (x[1] ^2) + 5/pi * x[1]  - 6)^2 + 
10 * (1 - 1/(8 * pi)) * cos(x[1] ) + 10
}
## Create design points
set.seed(1)
x <- cbind(runif(20)*15-5,runif(20)*15)
## Compute observations at design points (for Branin function)
y <- as.matrix(apply(x,1,braninFunction))
## Create model
fit <- buildRandomForest(x,y,control = list(algTheta=optimLHD))
## Print model parameters
print(fit)
## Predict at new location
predict(fit,cbind(1,2))
## True value at location
braninFunction(c(1,2))
}
}
