% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildKrigingDACE.R
\name{corrkriging}
\alias{corrkriging}
\title{Correlation:  Kriging}
\usage{
corrkriging(theta, d, ret = "all")
}
\arguments{
\item{theta}{parameters in the correlation function}

\item{d}{m*n matrix with differences between given data points}

\item{ret}{A string. If set to \code{"all"} or \code{"dr"}, the derivative of \code{r} (\code{dr}) will be returned, else \code{dr} is \code{NA}.}
}
\value{
returns a list with two elements:
			\item{\code{r}}{correlation}
			\item{\code{dr}}{m*n matrix with the Jacobian of \code{r} at \code{x}. It is
          assumed that \code{x} is given implicitly by \code{d[i,] = x - S[i,]},
          where \code{S[i,]} is the \code{i}'th design site.}
}
\description{
Kriging correlation function, no nugget
}
\seealso{
\code{\link{buildKrigingDACE}}
}
\author{
The authors of the original DACE Matlab code
are Hans Bruun Nielsen, Soren Nymand Lophaven and Jacob Sondergaard. \cr
Extension of the Matlab code by Tobias Wagner \email{wagner@isf.de}. \cr 
Ported to R by Martin Zaefferer \email{martin.zaefferer@fh-koeln.de}.
}
\keyword{internal}
