% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getModelConf.R
\name{getModelConf}
\alias{getModelConf}
\title{Get model configuration}
\usage{
getModelConf(
  modelArgs = NULL,
  model,
  task.type = NULL,
  nFeatures = NULL,
  active = NULL
)
}
\arguments{
\item{modelArgs}{list with information about model, active variables etc. Note:
\code{argList} will replace the other arguments. Use \code{argList$model} instead
of \code{model} etc.}

\item{model}{machine or deep learning model (character). One of the following:
\describe{
    \item{\code{"cvglmnet"}}{glm net.}
    \item{\code{"kknn"}}{nearest neighbour.}
    \item{\code{"ranger"}}{random forest.}
    \item{\code{"rpart"}}{recursive partitioning and  regression trees, \code{\link[rpart]{rpart}}}
    \item{\code{"svm"}}{support vector machines.}
    \item{\code{"xgboost"}}{gradient boosting, \code{\link[xgboost]{xgb.train}}.}
    \item{\code{"dl"}}{deep learning: dense network.}
    \item{\code{"cnn"}}{deep learning: convolutionary network}.}}

\item{task.type}{character, either \code{"classif"} or \code{"regr"}.}

\item{nFeatures}{number of features, e.g., \code{sum(task$task.desc$n.feat)}}

\item{active}{vector of activated tunepars, e.g., \code{c("minsplit", "maxdepth")}
for model \code{"rpart"}}
}
\value{
Returns returns a list of the
machine learning model configuration and corresponding hyperparameters:
\describe{
	\item{\code{learner}}{character: combination of task.type and model name.}
	\item{\code{lower}}{vector of lower bounds.}
	\item{\code{upper}}{vector of upper bounds.}
	\item{\code{fixpars}}{list of fixed parameters.}
	\item{\code{factorlevels}}{list of factor levels.}
	\item{\code{transformations}}{vector of transformations.}
	\item{\code{dummy}}{logical. Use dummy encoding, e.g., \code{\link[xgboost]{xgb.train}}}
	\item{\code{relpars}}{list of relative hyperparameters.}
}
}
\description{
Configure machine and deep learning models
}
\examples{
# Get hyperparameter names and their defaults for fitting a
# (recursive partitioning and  regression trees) model:
modelArgs <- list(model = "rpart")
cfg <- getModelConf(modelArgs)
cfg$tunepars
cfg$defaults
## do not use anymore:
cfg <- getModelConf(model="rpart")
cfg$tunepars
cfg$defaults
modelArgs <- list(model="rpart", active = c("minsplit", "maxdepth"))
cfgAct <- getModelConf(modelArgs)
cfgAct$tunepars
cfgAct$defaults

}
