% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{srt.write}
\alias{srt.write}
\title{Srt Output}
\usage{
srt.write(srt, filename)
}
\arguments{
\item{srt}{vector. The srt file read by \code{\link[SRTtools]{srt.read}}.}

\item{filename}{Either a character string naming a file or a connection open for writing.}
}
\description{
Write the srt file to the system.
}
\examples{
srt_path <- system.file("extdata", "movie.srt", package="SRTtools")
srt <- srt.read(srt_path, encoding = 'utf-8')

# Postpone subtitles 3 seconds later
srt <- srt.shift(srt, time_shifted = 3)

# Save and cover original "movie.srt" file
srt.write(srt, filename =  file.path(tempdir(), "movie.srt"))

}
\seealso{
\code{\link[SRTtools]{srt.read}}
}
