% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/USMLeastSquaresClassifier.R
\name{USMLeastSquaresClassifierSSLR}
\alias{USMLeastSquaresClassifierSSLR}
\title{General Interface for USMLeastSquaresClassifier (Updated Second Moment Least Squares Classifier) model}
\usage{
USMLeastSquaresClassifierSSLR(
  lambda = 0,
  intercept = TRUE,
  x_center = FALSE,
  scale = FALSE,
  y_scale = FALSE,
  ...,
  use_Xu_for_scaling = TRUE
)
}
\arguments{
\item{lambda}{numeric; L2 regularization parameter}

\item{intercept}{logical; Whether an intercept should be included}

\item{x_center}{logical;  Should the features be centered?}

\item{scale}{logical; Should the features be normalized? (default: FALSE)}

\item{y_scale}{logical; whether the target vector should be centered}

\item{...}{Not used}

\item{use_Xu_for_scaling}{logical; whether the unlabeled objects should be used to determine the mean and scaling for the normalization}
}
\description{
model from RSSL package
This methods uses the closed form solution of the supervised least squares problem,
except that the second moment matrix (X'X) is exchanged with a second moment matrix that
is estimated based on all data. See for instance \cite{Shaffer1991}, where in this
implementation we use all data to estimate E(X'X), instead of just the labeled data.
This method seems to work best when the data is first centered \code{x_center=TRUE}
and the outputs are scaled using \code{y_scale=TRUE}.
}
\examples{
library(tidyverse)
library(tidymodels)
library(caret)
library(SSLR)

data(breast)

set.seed(1)
train.index <- createDataPartition(breast$Class, p = .7, list = FALSE)
train <- breast[ train.index,]
test  <- breast[-train.index,]

cls <- which(colnames(breast) == "Class")

#\% LABELED
labeled.index <- createDataPartition(breast$Class, p = .2, list = FALSE)
train[-labeled.index,cls] <- NA


m <- USMLeastSquaresClassifierSSLR() \%>\% fit(Class ~ ., data = train)

#Accuracy
predict(m,test) \%>\%
  bind_cols(test) \%>\%
  metrics(truth = "Class", estimate = .pred_class)

}
\references{
Shaffer, J.P., 1991. The Gauss-Markov Theorem and Random Regressors. The American Statistician, 45(4), pp.269-273.
}
