% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.SSN2}
\alias{plot.SSN2}
\alias{plot.ssn_lm}
\alias{plot.ssn_glm}
\title{Plot fitted model diagnostics}
\usage{
\method{plot}{ssn_lm}(x, which, ...)

\method{plot}{ssn_glm}(x, which, ...)
}
\arguments{
\item{x}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{which}{An integer vector taking on values between 1 and 6, which indicates
the plots to return. Available plots are described in Details. If \code{which}
has length greater than one, additional plots are stepped through in order
using \code{<Return>}. The default is \code{which = c(1, 2)}}

\item{...}{Other arguments passed to other methods.}
}
\value{
No return value. Function called for plotting side effects.
}
\description{
Plot fitted model diagnostics such as residuals vs fitted values,
quantile-quantile, scale-location, Cook's distance, residuals vs leverage,
and Cook's distance vs leverage.
}
\details{
For all fitted model objects,, the values of \code{which} make the
corresponding plot:
\itemize{
\item 1: Standardized residuals vs fitted values (of the response)
\item 2: Normal quantile-quantile plot of standardized residuals
\item 3: Scale-location plot of standardized residuals
\item 4: Cook's distance
\item 5: Standardized residuals vs leverage
\item 6: Cook's distance vs leverage
}
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
plot(ssn_mod, which = 1)
}
\seealso{
\code{\link[=plot.Torgegram]{plot.Torgegram()}}
}
