% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssn_check.R
\name{ssn_check}
\alias{ssn_check}
\title{Check an \code{SSN} object}
\usage{
ssn_check(ssn.object, check_obs = TRUE, afv_col = NULL, verbose = TRUE)
}
\arguments{
\item{ssn.object}{An \code{SSN} object created using \code{\link[SSNbler]{ssn_assemble}} or imported using \code{\link[SSN2]{ssn_import}}.}

\item{check_obs}{A logical indicating whether the observations should be checked. Default = \code{TRUE}.}

\item{afv_col}{Character vector containing  names of columns containing additive function values. The Default = \code{NULL}.}

\item{verbose}{Logical \code{TRUE/FALSE} indicating whether details describing the checks are printed to the console. If \code{verbose = FALSE}, a logical \code{TRUE/FALSE} is returned indicating whether the \code{SSN} object passed all of the checks. Default = \code{TRUE}.}
}
\value{
Boolean indicating whether the \code{SSN} object is valid. If \code{verbose = TRUE}, additional messages are printed to the console describing potential issues with the \code{SSN} object.
}
\description{
Check an \code{SSN} (spatial stream network) object to ensure that it contains valid spatial, topological, and attribute information needed to fit spatial statistical stream network models using the 'SSN2' package.
}
\examples{
## Create local temporary copy of MiddleFork04.ssn found in
## the SSN2 package. Only necessary for this example.
SSN2::copy_lsn_to_temp()

# Import the SSN object with prediction points, pred1km
mf04 <- SSN2::ssn_import(
  paste0(tempdir(), "/MiddleFork04.ssn"),
  predpts = c("pred1km"),
  overwrite = TRUE
)

# Check the SSN object, including the additive function column,
# afvArea
ssn_check(mf04, afv_col = "afvArea")

}
