% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ssrmst.R
\docType{package}
\name{SSRMST-package}
\alias{SSRMST-package}
\title{Sample Size Calculation using Restricted Mean Survival Time}
\description{
The differences in restricted mean survival times (RMST), a clinically interpretable model-free measure, can be one of the alternatives to the hazard ratio.
 The package calculates the study sample size and power in designing clinical trials using the differences in RMSTs.
 Two types of one-sided tests, non-inferiority and superiority tests, are prepared.
}
\details{


Please check the vignette for details: \code{browseVignettes(package = "SSRMST")}
}
\examples{
#---Example data

 ac_rate   = 15
 ac_period = 35
 tot_time  = 510
 tau       = 500
 scale0    = 8500
 scale1    = 8500
 margin    = 18

 a = ssrmst(ac_rate, ac_period, tot_time, tau, scale0, scale1, margin=margin, ntest=20)
 print(a)
}
\author{
Miki Horiguchi
}
\references{
Uno H, Claggett B, Tian L, Inoue E, Gallo P, Miyata T, Schrag D, Takeuchi M, Uyama Y, Zhao L,
 Skali H, Solomon S, Jacobus S, Hughes M, Packer M, Wei LJ. Moving beyond the hazard ratio in
 quantifying the between-group difference in survival analysis. Journal of clinical Oncology 2014,
 32, 2380-2385.

 Uno H, Wittes J, Fu H, Solomon SD, Claggett B, Tian L, Cai T, Pfeffer MA, Evans SR, Wei LJ.
 Alternatives to Hazard Ratios for Comparing the Efficacy or Safety of Therapies in non-inferiority Studies.
 Annals of Internal Medicine 2015, 163, 127-134.
}
\seealso{
survival
 survRM2
}

