% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_stic_data.R
\name{validate_stic_data}
\alias{validate_stic_data}
\title{validate_stic_data.R}
\usage{
validate_stic_data(stic_data, field_observations)
}
\arguments{
\item{stic_data}{classified STIC data frame with the variable names of that produced by \link{classify_wetdry}}

\item{field_observations}{The input data frame of field observations must include a \code{datetime} column (in Posixct format), as well as a column labeled \code{wetdry} consisting of the character strings “wet” or “dry” (as in the processed STIC data itself). Additionally, if field data on SpC was collected (e.g., with a sonde), this should be included as a third column called \code{SpC}, and units should be in µS/cm.}
}
\value{
A confusion matrix (if just field wet/dry observations are included) and an SpC scatter plot if field measurements of SpC are included.
}
\description{
This function takes a data frame with field observations of wet/dry status and SpC and generates both a confusion matrix for the wet/dry observations and a scatterplot comparing estimated SpC from the STICs to field-measured values.
}
\examples{
data_validation_confusion_matrix <-
  validate_stic_data(
    stic_data = classified_df,
    field_observations = field_obs
  )
}
