% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{top5motifs}
\alias{top5motifs}
\title{Plot the 5 motifs}
\usage{
top5motifs(dataset, rankList, alpha)
}
\arguments{
\item{dataset}{Dataset containing numeric values}

\item{rankList}{List of ranked motifs}

\item{alpha}{Number of letters used to do the encode}
}
\value{
Pixelated dataset
}
\description{
Display the intensity of values and higthlight the top five motifs
}
\examples{
#Launch all the workflow
candidates <- STSIdentifyCandidateSTMotifs(STMotif::example_dataset, 10, 10, 7, 3)
stmotifs <- STSIdentifySTMotifs(candidates, 1, 1)
sttightmotifs <- STSIdentifyTightSTMotifs(stmotifs, candidates$rectangles)
rankResult <- STSRankTightSTMotifs(sttightmotifs)

#Plot the result
top5motifs(dataset = STMotif::example_dataset, rankList = rankResult, alpha = 7)
}
