% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/release.R
\name{release}
\alias{release}
\title{Create a Release period}
\usage{
release(
  ...,
  prescription_1RM = 100,
  additive_1RM_adjustment = 2.5,
  multiplicative_1RM_adjustment = 1,
  rounding = 2.5,
  max_perc_1RM_func = max_perc_1RM_epley
)
}
\arguments{
\item{...}{\code{STMr_scheme} objects create by \code{scheme_} functions}

\item{prescription_1RM}{Initial prescription planning 1RM to calculate weight
Default is 100}

\item{additive_1RM_adjustment}{Additive 1RM adjustment across phases. Default is 2.5}

\item{multiplicative_1RM_adjustment}{multiplicative 1RM adjustment across phases.
Default is 1 (i.e., no adjustment)}

\item{rounding}{Rounding for the calculated weight. Default is 2.5}

\item{max_perc_1RM_func}{Max Perc 1RM function to use when calculating
\code{load_1RM}. Default is \code{\link{max_perc_1RM_epley}}}
}
\value{
\code{STMr_relase} data frame
}
\description{
Release combines multiple schemes together with \code{prescription_1RM},
\code{additive_1RM_adjustment}, and \code{multiplicative_1RM_adjustment}
parameters to calculate working \code{weight}, \code{load_1RM}, and
\code{buffer}
}
\examples{
scheme1 <- scheme_step(vertical_planning = vertical_constant)
scheme2 <- scheme_step(vertical_planning = vertical_linear)
scheme3 <- scheme_step(vertical_planning = vertical_undulating)

release_df <- release(
  scheme1, scheme2, scheme3,
  additive_1RM_adjustment = 2.5
)

plot(release_df)
}
