% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitINLA.R
\name{smoothDirect}
\alias{smoothDirect}
\alias{fitINLA}
\title{Smoothed direct estimates for mortality rates}
\usage{
smoothDirect(data, Amat, X = NULL, formula = NULL,
  time.model = c("rw1", "rw2", "ar1")[2], st.time.model = NULL,
  year_label, year_range = c(1980, 2014), is.yearly = TRUE, m = 5,
  type.st = 1, survey.effect = FALSE, hyper = c("pc", "gamma")[1],
  pc.u = 1, pc.alpha = 0.01, pc.u.phi = 0.5, pc.alpha.phi = 2/3,
  pc.u.cor = 0.7, pc.alpha.cor = 0.9, pc.st.u = NA,
  pc.st.alpha = NA, options = list(dic = TRUE, mlik = TRUE, cpo = TRUE,
  openmp.strategy = "default"), control.inla = list(strategy =
  "adaptive", int.strategy = "auto"), verbose = FALSE, geo = NULL,
  rw = NULL, ar = NULL)

fitINLA(data, Amat, X = NULL, formula = NULL, time.model = c("rw1",
  "rw2", "ar1")[2], st.time.model = NULL, year_label,
  year_range = c(1980, 2014), is.yearly = TRUE, m = 5, type.st = 1,
  survey.effect = FALSE, hyper = c("pc", "gamma")[1], pc.u = 1,
  pc.alpha = 0.01, pc.u.phi = 0.5, pc.alpha.phi = 2/3,
  pc.u.cor = 0.7, pc.alpha.cor = 0.9, pc.st.u = NA,
  pc.st.alpha = NA, options = list(dic = TRUE, mlik = TRUE, cpo = TRUE,
  openmp.strategy = "default"), control.inla = list(strategy =
  "adaptive", int.strategy = "auto"), verbose = FALSE, geo = NULL,
  rw = NULL, ar = NULL)
}
\arguments{
\item{data}{Combined dataset}

\item{Amat}{Adjacency matrix for the regions}

\item{X}{Covariate matrix. It must contain either a column with name "region", or a column with name "years", or both. The covariates must not have missing values for all regions (if varying in space) and all time periods (if varying in time). The rest of the columns are treated as covariates in the mean model.}

\item{formula}{INLA formula. See vignette for example of using customized formula.}

\item{time.model}{Model for the main temporal trend, can be rw1, rw2, or ar1. ar1 is not implemented for yearly model with period data input. Default to be rw2. For ar1 main effect, a linear slope is also added with time scaled to be between -0.5 to 0.5, i.e., the slope coefficient represents the total change between the first year and the last year in the projection period on the logit scale.}

\item{st.time.model}{Temporal component model for the interaction term, can be rw1, rw2, or ar1. ar1 is not implemented for yearly model with period data input. Default to be the same as time.model unless specified otherwise. For ar1 interaction model, region-specific random slopes can be added by specifying \code{pc.st.slope.u} and \code{pc.st.slope.alpha}.}

\item{year_label}{string vector of year names}

\item{year_range}{Entire range of the years (inclusive) defined in year_label.}

\item{is.yearly}{Logical indicator for fitting yearly or period model.}

\item{m}{Number of years in each period.}

\item{type.st}{type for space-time interaction}

\item{survey.effect}{logical indicator whether to include a survey iid random effect. If this is set to TRUE, there needs to be a column named 'survey' in the input data frame. In prediction, this random effect term will be set to 0.}

\item{hyper}{which hyperpriors to use. Default to be using the PC prior ("pc").}

\item{pc.u}{hyperparameter U for the PC prior on precisions.}

\item{pc.alpha}{hyperparameter alpha for the PC prior on precisions.}

\item{pc.u.phi}{hyperparameter U for the PC prior on the mixture probability phi in BYM2 model.}

\item{pc.alpha.phi}{hyperparameter alpha for the PC prior on the mixture probability phi in BYM2 model.}

\item{pc.u.cor}{hyperparameter U for the PC prior on the autocorrelation parameter in the AR prior, i.e. Prob(cor > pc.u.cor) = pc.alpha.cor.}

\item{pc.alpha.cor}{hyperparameter alpha for the PC prior on the autocorrelation parameter in the AR prior.}

\item{pc.st.u}{hyperparameter U for the PC prior on precisions for the interaction term.}

\item{pc.st.alpha}{hyperparameter alpha for the PC prior on precisions for the interaction term.}

\item{options}{list of options to be passed to control.compute() in the inla() function.}

\item{control.inla}{list of options to be passed to control.inla() in the inla() function. Default to the "adaptive" integration strategy.}

\item{verbose}{logical indicator to print out detailed inla() intermediate steps.}

\item{geo}{Deprecated.}

\item{rw}{Deprecated.}

\item{ar}{Deprecated.}
}
\value{
List of fitted object
}
\description{
The function \code{smoothDirect} replaces the previous function name \code{fitINLA} (before version 1.0.0).
}
\examples{
\dontrun{
years <- levels(DemoData[[1]]$time)
# obtain direct estimates
data_multi <- getDirectList(births = DemoData, years = years,
  regionVar = "region",  timeVar = "time", clusterVar = "~clustid+id",
  ageVar = "age", weightsVar = "weights", geo.recode = NULL)
data <- aggregateSurvey(data_multi)

#  national model
years.all <- c(years, "15-19")
fit1 <- smoothDirect(data = data, Amat = NULL, 
  year_label = years.all, year_range = c(1985, 2019), 
  rw = 2, is.yearly=FALSE, m = 5)
out1 <- getSmoothed(fit1)
plot(out1, is.subnational=FALSE)

#  subnational model
fit2 <- smoothDirect(data = data, Amat = DemoMap$Amat, 
  year_label = years.all, year_range = c(1985, 2019), 
  rw = 2, is.yearly=TRUE, m = 5, type.st = 4)
out2 <- getSmoothed(fit2)
plot(out2,  is.subnational=TRUE)


}
}
\references{
Li, Z., Hsiao, Y., Godwin, J., Martin, B. D., Wakefield, J., Clark, S. J., & with support from the United Nations Inter-agency Group for Child Mortality Estimation and its technical advisory group. (2019). \emph{Changes in the spatial distribution of the under-five mortality rate: Small-area analysis of 122 DHS surveys in 262 subregions of 35 countries in Africa.} PloS one, 14(1), e0210645.

Mercer, L. D., Wakefield, J., Pantazis, A., Lutambi, A. M., Masanja, H., & Clark, S. (2015). \emph{Space-time smoothing of complex survey data: small area estimation for child mortality.} The annals of applied statistics, 9(4), 1889.
}
\seealso{
\code{\link{getDirect}}
}
\author{
Zehang Richard Li
}
