% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svem_significance_test.R
\name{svem_significance_test}
\alias{svem_significance_test}
\title{SVEM Significance Test with Mixture Support}
\usage{
svem_significance_test(
  formula,
  data,
  mixture_groups = NULL,
  nPoint = 2000,
  nSVEM = 10,
  nPerm = 150,
  percent = 90,
  nBoot = 100,
  glmnet_alpha = c(1),
  weight_scheme = c("SVEM"),
  objective = c("auto", "wAIC", "wBIC", "wGIC", "wSSE"),
  auto_ratio_cutoff = 1.3,
  gamma = 2,
  relaxed = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{formula}{A formula specifying the model to be tested.}

\item{data}{A data frame containing the variables in the model.}

\item{mixture_groups}{Optional list describing one or more mixture factor
groups. Each element of the list should be a list with components
\code{vars} (character vector of column names), \code{lower} (numeric vector of
lower bounds of the same length as \code{vars}), \code{upper} (numeric vector
of upper bounds of the same length), and \code{total} (scalar specifying the
sum of the mixture variables). All mixture variables must be
included in \code{vars}, and no variable can appear in more than one
mixture group. Defaults to \code{NULL} (no mixtures).}

\item{nPoint}{Number of random points in the factor space (default: 2000).}

\item{nSVEM}{Number of SVEM fits on the original data (default: 10).}

\item{nPerm}{Number of SVEM fits on permuted responses for the reference
distribution (default: 150).}

\item{percent}{Percentage of variance to capture in the SVD (default: 90).}

\item{nBoot}{Number of bootstrap iterations within each SVEM fit (default: 100).}

\item{glmnet_alpha}{The alpha parameter(s) for glmnet (default: \code{c(1)}).}

\item{weight_scheme}{Weighting scheme for SVEM (default: "SVEM").}

\item{objective}{Objective used inside \code{SVEMnet()} to pick the bootstrap
path solution. One of \code{"auto"}, \code{"wAIC"}, \code{"wBIC"},
\code{"wGIC"}, \code{"wSSE"} (default: \code{"auto"}).}

\item{auto_ratio_cutoff}{Single cutoff for the automatic rule when
\code{objective = "auto"} (default 1.3). With \code{r = n_X/p_X}, if
\code{r >= auto_ratio_cutoff} use wAIC; else wBIC. Passed to \code{SVEMnet()}.}

\item{gamma}{Penalty weight used only when \code{objective = "wGIC"} (default 2).
Passed to \code{SVEMnet()}.}

\item{relaxed}{Logical; default \code{FALSE}. When \code{TRUE}, inner
\code{SVEMnet()} fits use glmnet's relaxed elastic net path and select both
lambda and relaxed gamma on each bootstrap. When \code{FALSE}, the standard
glmnet path is used. This value is passed through to \code{SVEMnet()}.
Note: if \code{relaxed = TRUE} and \code{glmnet_alpha} includes \code{0}, ridge
(\code{alpha = 0}) is dropped by \code{SVEMnet()} for relaxed fits.}

\item{verbose}{Logical; if \code{TRUE}, displays progress messages (default: \code{TRUE}).}

\item{...}{Additional arguments passed to \code{SVEMnet()} and then to \code{glmnet()}
(for example: \code{penalty.factor}, \code{offset}, \code{lower.limits},
\code{upper.limits}, \code{standardize.response}, etc.). The \code{relaxed}
setting is controlled by the \code{relaxed} argument of this function and
any \code{relaxed} value passed via \code{...} is ignored with a warning.}
}
\value{
A list of class \code{svem_significance_test} containing:
\itemize{
\item \code{p_value}: median p-value across evaluation points.
\item \code{p_values}: vector of per-point p-values.
\item \code{d_Y}: distances for original fits.
\item \code{d_pi_Y}: distances for permutation fits.
\item \code{distribution_fit}: fitted SHASHo distribution object.
\item \code{data_d}: data frame combining distances and labels.
}
}
\description{
Performs a whole-model significance test using the SVEM framework and allows
the user to specify mixture factor groups. Mixture factors are sets of
continuous variables that are constrained to sum to a constant (the
mixture total) and have optional lower and upper bounds. When mixture
groups are supplied, the grid of evaluation points is generated by
sampling Dirichlet variates over the mixture simplex rather than by
independently sampling each continuous predictor. Non-mixture
continuous predictors are sampled via a maximin Latin hypercube over
their observed ranges, and categorical predictors are sampled from
their observed levels.
}
\details{
If no mixture groups are supplied, this function behaves identically
to a standard SVEM-based whole-model test, sampling non-mixture continuous
variables via a maximin Latin hypercube within their observed ranges,
and categorical variables from their observed levels.

Internally, predictions at evaluation points use \code{predict.svem_model()}
with \code{se.fit = TRUE}. Rows with unseen categorical levels are returned
as \code{NA} and are excluded from distance summaries via \code{complete.cases()}.
}
\seealso{
\code{SVEMnet()}, \code{predict.svem_model()}
}
