% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigexp.R
\name{bigexp_terms}
\alias{bigexp_terms}
\title{Create a deterministic expansion spec for wide polynomial/interaction models}
\usage{
bigexp_terms(
  formula,
  data,
  factorial_order = 3L,
  discrete_threshold = 2L,
  include_pure_cubic = FALSE,
  include_pc_3way = FALSE,
  intercept = TRUE
)
}
\arguments{
\item{formula}{Main-effects formula on the RHS (no \code{:}/\code{^}/\code{I()} there). \code{y ~ .} allowed.}

\item{data}{Data frame used to decide types and lock factor levels.}

\item{factorial_order}{Integer, 2 or 3 (default 3).}

\item{discrete_threshold}{Numeric predictors with <= this many unique finite
values are treated as categorical (default 2).}

\item{include_pure_cubic}{Logical; include \code{I(X^3)} for continuous predictors (default FALSE).}

\item{include_pc_3way}{Logical; include partial-cubic 3-ways \code{I(X^2):Z:W} (default FALSE).}

\item{intercept}{Include intercept (default TRUE).}
}
\value{
An object of class \code{"bigexp_spec"} with components:
\itemize{
\item \code{formula} — expanded formula (\code{y ~ ...}) using the training response.
\item \code{rhs} — the right-hand-side expansion string, reusable for any response.
\item \code{vars} — predictor names (in the order discovered from \code{formula}/\code{data}).
\item \code{is_cat} — named logical: categorical vs continuous.
\item \code{levels} — list of locked factor levels (level order preserved).
\item \code{num_range} — 2 x p matrix of ranges for continuous vars (informational).
\item \code{settings} — list of expansion settings, including saved contrasts.
}
}
\description{
Builds a specification that locks variable types and factor levels from \code{data},
then encodes a large expansion:
\itemize{
\item Full factorial up to 2- or 3-way among the listed main effects
\item Response surface (squares of continuous predictors)
\item Partial cubic crosses (I(X^2):Z, optionally 3-way I(X^2):Z:W)
}
}
\details{
Provide a main-effects formula (e.g., \code{y ~ X1 + X2 + G} or \code{y ~ .}).
The function constructs the complex RHS and records factor levels so that
future datasets expand identically.
}
\examples{
# spec <- bigexp_terms(y ~ X1 + X2 + G, data = df, factorial_order = 3)
}
