/*
 * Decompiled with CFR 0.152.
 */
package cea.dsv.ibitecs.org;

import cea.dsv.ibitecs.org.SVGNamespaceContext;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGRect;

public class BBox {
    public String Filename;
    public SVGDocument doc;
    public XPath xpath;
    public Node root;

    public BBox() {
    }

    public BBox(String filename) {
        this.Filename = filename;
        this.init();
    }

    public String getFilename() {
        return this.Filename;
    }

    public void setFilename(String filename) {
        this.Filename = filename;
    }

    public double[] getBBox(String xpathQuery) {
        try {
            XPathExpression expr = this.xpath.compile(xpathQuery);
            NodeList nodes = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            if (nodes.getLength() > 0) {
                Node node = nodes.item(0);
                SVGRect bbox = ((SVGLocatable)node).getBBox();
                if (bbox != null) {
                    double[] boxlist = new double[]{bbox.getX(), bbox.getY(), bbox.getWidth(), bbox.getHeight()};
                    return boxlist;
                }
                return null;
            }
            return null;
        }
        catch (XPathExpressionException e) {
            System.err.println("XPath Error: " + e.getMessage());
            return null;
        }
    }

    public void init() {
        try {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
            File file = new File(this.Filename);
            URI uri = file.toURI();
            this.doc = f.createSVGDocument(uri.toString());
            this.root = this.doc.getRootElement();
            UserAgentAdapter userAgent = new UserAgentAdapter();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
            ctx.setDynamicState(2);
            GVTBuilder builder = new GVTBuilder();
            builder.build(ctx, (Document)this.doc);
        }
        catch (IOException e) {
            System.err.println("Oopss. failed to read:" + e.getMessage() + "\n");
        }
        XPathFactory factory = XPathFactory.newInstance();
        this.xpath = factory.newXPath();
        SVGNamespaceContext ns = new SVGNamespaceContext();
        this.xpath.setNamespaceContext(ns);
    }

    public static void main(String[] args) {
        System.out.println("Batik Bounding Box Test..");
        BBox boxTest = new BBox(args[0]);
        double[] res = boxTest.getBBox(args[1]);
        if (res != null) {
            System.out.println("Bounding Box: x=" + res[0] + " y=" + res[1] + " w=" + res[2] + " h=" + res[3]);
        } else {
            System.out.println("No bounding box calculated..");
        }
    }
}

