% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_shp_file.R
\name{load_shp_file}
\alias{load_shp_file}
\title{Load and format shapefile for reserve level map}
\usage{
load_shp_file(path, dissolve_boundaries = TRUE)
}
\arguments{
\item{path}{path to shapefile and name}

\item{dissolve_boundaries}{logical, should reserve boundaries be dissolved? Defaults to \code{TRUE}}
}
\value{
Returns a \code{\link[sf]{sf}} object
}
\description{
Load and format shapefile for use with res_local_map. If polygons are dissolved, the only attribute returned will be a count of the number of grouped polygons, otherwise, all attrributes are retained.
}
\details{
This function is intended for internal use with the NERRS reserve level reporting scripts. It loads a NERRS boundary shp file and dissolves unnecessary reserve boundaries. The resulting \code{sf} object is then used with \code{\link{res_sk_map}} and \code{\link{res_local_map}}
}
\author{
Julie Padilla, Dave Eslinger
}
\concept{reporting}
