% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_invalsi_IS.R
\name{Get_Invalsi_IS}
\alias{Get_Invalsi_IS}
\title{Download the Invalsi census survey data}
\source{
\href{https://serviziostatistico.invalsi.it/invalsi_ss_data/dati-comunali-di-popolazione-comune-del-plesso/}{Municipality data};
                      \href{https://serviziostatistico.invalsi.it/invalsi_ss_data/dati-provinciali-di-popolazione/}{Province data}
}
\usage{
Get_Invalsi_IS(level = "LAU", verbose = TRUE, show_col_types = FALSE)
}
\arguments{
\item{level}{Character. The level of aggregation of Invalsi census data. Either \code{"NUTS-3"}, \code{"Province"}, \code{"LAU"}, \code{"Municipality"}. \code{"LAU"} by default.}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. \code{TRUE} by default.}

\item{show_col_types}{Logical. If \code{TRUE}, if the \code{verbose} argument is also \code{TRUE}, the columns of the raw dataset are shown during the download. \code{FALSE} by default.}
}
\value{
An object of class \code{tbl_df}, \code{tbl} and \code{data.frame}
}
\description{
Downloads the full database of the Invalsi scores, detailed either at the municipality or province level.
The format is intermediate between long and short, since the numeric variables are:
\itemize{
  \item \code{Average_percentage_score} Average direct score (percentage of sufficient tests)
  \item \code{Std_dev_percentage_score} Standard deviation of the direct score
  \item \code{WLE_average_score} Average WLE score. The WLE score is calculated through the Rasch's psychometric model and is suitable for middle and high schools in that it is cleaned from the effect of cheating  (which would affect both the average score and the score variability). By construction it has a mean around 200 points.
  \item \code{Std_dev_WLE_score} Standard deviation of the WLE score. By construction it ranges around 40 points at the school level.
  \item \code{Students_coverage} Students coverage percentage
}
}
\examples{
\donttest{
Get_Invalsi_IS(level = "NUTS-3")
}


}
