% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{linearAlgebra}
\alias{linearAlgebra}
\alias{mat}
\alias{singvals}
\title{Functions for teaching linear algebra.}
\usage{
mat(formula, data = parent.frame())

singvals(formula, data = parent.frame())
}
\arguments{
\item{formula}{a formula as \code{~ a or ~ a + b}.  In \code{mat} and \code{singvals},
only the right-hand side is used.}

\item{data}{a data frame from which to pull out numerical values
for the variables in the formula}

\item{\dots}{additional arguments (currently ignored)


\code{mat} returns a model matrix

To demonstrate singularity, use \code{singvals}.}
}
\value{
\code{mat} returns a matrix

\code{singvals} gives singular values for each column in the model matrix
}
\description{
These functions provide a formula based interface to the construction
of matrices from data and for fitting.  You can use them both for numerical vectors
and for functions of variables in data frames.
These functions are intended to support teaching basic linear algebra
with a particular connection to statistics.
}
\examples{
a <- c(1,0,0); b <- c(1,2,3); c <- c(4,5,6); x <- rnorm(3)
# Formula interface
mat(~a+b)
mat(~a+b+1)

data(tobaccovote)
mat(~votedpro+party, data=tobaccovote)
singvals(~votedpro*party*money*acres, data=tobaccovote)
}

