% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/by.data.frame.R
\name{as.data.frame.by}
\alias{as.data.frame.by}
\title{Convert the results of by() to a data.frame.}
\usage{
\method{as.data.frame}{by}(x, row.names = NULL, optional = FALSE,
  colnames = paste("IDX", seq(length(dim(x))), sep = ""), na.rm = TRUE, ...)
}
\arguments{
\item{x}{The by object}

\item{row.names}{Names of the rows. If NULL, function tries guessing them.}

\item{optional}{Ignored.}

\item{colnames}{Names of columns}

\item{na.rm}{Remove NAs or not.}

\item{\dots}{Pass-alongs.}
}
\value{
A data.frame.
}
\description{
Converts the results of by() to a data.frame if possible,  (reducing dimensionality and adding repetition as necessary)
}
\examples{
sex    <- factor(rbinom(1:1000, 1, 0.5), labels=c("male" , "female"));
age    <- sample(1:100, 1000, rep=TRUE);
weight <- factor(rbinom(1:1000, 2, 0.6), labels=c("light", "middle", "heavy"))
by(age, sex, mean)
}

