% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/electoralTool.R
\name{farina}
\alias{farina}
\title{Farina index}
\usage{
farina(v, s)
}
\arguments{
\item{v}{A vector containing the votes for each political party.}

\item{s}{A vector containing the election outcome as seats.}
}
\value{
A single score given the vector of votes and the vector for seats.
}
\description{
Calculates the Farina index also referred to as the cosine proportionality score based on a vector of votes and a vector for the electoral outcome.
}
\examples{
# 2012 Queensland state elecion
pvotes= c(49.65, 26.66, 11.5, 7.53, 3.16, 1.47)
pseats = c(87.64, 7.87, 2.25, 0.00, 2.25, 0.00)

farina(pvotes, pseats)
}
\author{
Daniel Marcelino \email{dmarcelino@live.com}
}
\references{
Koppel, M., and A. Diskin. (2009) Measuring disproportionality, volatility and malapportionment: axiomatization and solutions. Social Choice and Welfare 33, no. 2: 281-286.
}

