% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ci.R
\encoding{UTF-8}
\name{ci}
\alias{ci}
\title{An S4 Class to Confidence Intervals}
\usage{
ci(x, level = 0.95, alpha = 1 - level, na.rm = FALSE, ...)

ci(x, level = 0.95, alpha = 1 - level, na.rm = FALSE, ...)
}
\arguments{
\item{x}{A vector of data values.}

\item{level}{The confidence level. Default is \code{0.95}.}

\item{alpha}{The significance level. Default is \code{1-level}. If alpha equals 0.05, then your confidence level is 0.95.}

\item{na.rm}{A logical value, default is \code{FALSE}}

\item{\dots}{Additional arguements (currently ignored)}
}
\value{
\item{CI lower}{}
\item{Est. Mean}{Mean of data.}
\item{CI upper}{Upper bound of interval.}
\item{Std. Error}{Standard Error of the mean.}
}
\description{
An S4 Class to Confidence Intervals

Calculates the confidence intervals for a vector of data values.
}
\section{Slots}{

\describe{
\item{\code{lower}}{Lower bound of interval.}

\item{\code{mean}}{Estimated mean.}

\item{\code{upper}}{Upper bound of interval.}

\item{\code{stderr}}{Standard Error of the mean.}
}}
\examples{
x <- c(1, 2.3, 2, 3, 4, 8, 12, 43, -1,-4)

ci(x, level=.90)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}.
}
\keyword{Exploratory}

