% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/geom_foot.R
\encoding{UTF-8}
\name{geom_foot}
\alias{geom_foot}
\title{Add Footnote to a ggplot Object}
\usage{
geom_foot(text = NULL, fontsize = 10, color = NULL, rotn = 0,
  just = c("right", "bottom"))
}
\arguments{
\item{text}{any text or empty to use default.}

\item{fontsize}{the font size \code{text}.}

\item{color}{the color for \code{text}.}

\item{rotn}{the rotation for the footnote, default is \code{rotation=90}.}

\item{just}{the justification method.}
}
\description{
Add footnotes to \pkg{ggplot2} objects.
}
\details{
At this stage, this function only works for a ggplot object.
}
\examples{
# setup data
set.seed(51)
supply <- rnorm(100,mean=15-seq(1,6,by=.05),sd=1)
demand <- rnorm(100,mean=4+seq(1,21,by=.2),sd=.5)
time<-seq(1,100,by=1)
data <- data.frame(time, supply,demand)

# make the plot
library(ggplot2)
ggplot(data,aes(time)) +
geom_line(aes(y=demand),size=1.6, color="#008fd5") +
geom_line(aes(y=supply),size=1.6, color="#ff2700") +
theme_fte() +
annotate("text",x=90,y=12,label="Demand") +
annotate("text",x=80,y=23,label="Supply")
geom_foot("danielmarcelino.github.io", color = "#77ab43", rotn = -90, just ="right" )
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\keyword{Graphs}

