% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DISTRIBUTIONS.R
\encoding{UTF-8}
\name{normalpdf}
\alias{normalpdf}
\title{Normal probability density function}
\usage{
normalpdf(x, mu = 0, sigma = 1)
}
\arguments{
\item{x}{a vector of quantiles.}

\item{mu}{is the mean \eqn{\mu}, its default value is \eqn{\mu = 0}}

\item{sigma}{is the standard deviation \eqn{\sigma}, its default value is \eqn{\sigma = 1}}
}
\description{
Computes the pdf at each of the values in \emph{x} using the normal distribution with mean \eqn{\mu = 0} and standard deviation \eqn{\sigma = 1}.
}
\note{
The pdf function is given by:  \deqn{f(x) = \frac{1}{\sqrt{2 \pi} \sigma} \exp\left(\frac{- (x - \mu)^2}{2 \sigma^2}\right)}{f(x) = 1/(sqrt(2 \pi) \sigma) e^-((x - \mu)^2/(2 \sigma^2))}
for \eqn{\sigma > 0}
}
\examples{
normalpdf(x=1.2,mu=0,sigma=1)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\seealso{
\code{\link{draw.norm}}, \code{\link{normalcdf}}, \code{\link{invnormal}}.
#'
}
\keyword{Distribution}

