% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normalize.R
\encoding{UTF-8}
\name{Normalize}
\alias{Normalize}
\title{Unity-based normalization}
\usage{
Normalize(x, method = "range", ...)
}
\arguments{
\item{x}{is a vector to be normalized.}

\item{method}{A string for the method used for normalization. Default is \code{method = "range"}, which coerces values into [0,1] range. See details for other implemented methods.}

\item{\dots}{Additional arguements (currently ignored).}
}
\value{
Normalized values in an object of the same class as \code{x}.
}
\description{
Normalizes as feature scaling \code{min - max}, or unity-based
normalization typically used to bring the values into the range [0,1].
 Other methods are also available, including scoring, centering,
 and Smithson and Verkuilen (2006) method of dependent variable transformation.
}
\details{
The following methods are available:
\itemize{
\item {"range"}{Ranging is done by coercing \code{x} values into [0,1] range.
However, this may be generalized to follow the range of other arbitrary values
using  \code{a} and \code{b}: \deqn{X' = a + \frac{(x - x_{min})(b - a)}{(x_{max} - x_{min})}}}.
\item {"scale"}{Scaling is done by dividing (centered) values of \code{x} by
their standard deviations.}
\item {"center"}{Centering is done by subtracting the means (omitting NAs)
of \code{x} from its observed value.}
\item {"z-score"}{Scoring is done by dividing the values of \code{x}
from their root mean square.}
\item {"SV"}{Transform a dependent variable in [0,1] rather than (0, 1) to beta regression as suggested by Smithson and Verkuilen (2006).}
}
}
\examples{

x <- sample(10)
(y = Normalize(x) )

# equivalently to
(x-min(x))/(max(x)-min(x))

# Smithson and Verkuilen approach
(y = Normalize(x, method="SV") )

# look at what happens to the correlation of two independent variables and their "interaction"
# With non-centered interactions:
a = rnorm(10000,20,2)
b = rnorm(10000,10,2)
cor(a,b)
cor(a,a*b)

# With centered interactions:
c = a - 20
d = b - 10
cor(c,c*d)

}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\references{
Smithson M, Verkuilen J (2006) A Better Lemon Squeezer? Maximum-Likelihood
Regression with Beta-Distributed Dependent Variables.
\emph{Psychological Methods}, 11(1), 54-71.
}
\seealso{
\code{\link{scale}}.
}
\keyword{Modelling}
\keyword{Rescaling}
\keyword{Transformation}

