% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Waffleplot.R
\name{Waffleplot}
\alias{Waffleplot}
\title{Make waffle (square pie) charts}
\usage{
Waffleplot(parts, rows = 10, xlab = NULL, title = NULL, colors = NA,
  size = 2, legend_pos = "right", flip = FALSE, reverse = FALSE,
  equal = TRUE, pad = 0, use_glyph = FALSE, glyph_size = 12)
}
\arguments{
\item{parts}{named vector of values to use for the chart}

\item{rows}{number of rows of blocks}

\item{xlab}{text for below the chart. Highly suggested this be used to
give the "1 sq == xyz" relationship if it's not obvious}

\item{title}{chart title}

\item{colors}{exactly the number of colors as values in \code{parts}.
If omitted, Color Brewer "Set2" colors are used.}

\item{size}{width of the separator between blocks (defaults to \code{2})}

\item{legend_pos}{position of legend}

\item{flip}{flips x & y axes}

\item{reverse}{reverses the order of the data}

\item{equal}{by default, waffle uses \code{coord_equal}; this can cause
layout problems, so you an use this to disable it if you are using
ggsave or knitr to control output sizes (or manually sizing the chart)}

\item{pad}{how many blocks to right-pad the grid with}

\item{use_glyph}{use specified FontAwesome glyph}

\item{glyph_size}{size of the FontAwesome font}
}
\description{
Given a named vector, this function will return
a ggplot object that represents a waffle chart of the values.
 The individual values will be summed up and each that will be the total number of squares in the grid.
}
\note{
If the vector is not named or only partially named, capital letters will be
used instead. If you specify a string (vs \code{FALSE}) to \code{use_glyph} the function
will map the input to a FontAwesome glyph name and use that
 glyph for the tile instead of a block (making it more like an isotype pictogram than a
waffle chart). You'll need to actually install FontAwesome and use
the \code{extrafont} package (\code{https://github.com/wch/extrafont}) to
be able to use the FontAwesome glyphs.
}
\examples{
tiles <- c(One=80, Two=30, Three=20, Four=10)
Waffleplot(tiles, rows=8)

Senate <- c(`Male (44\%)`=44, `Female (56\%)`=56)
Waffleplot(Senate, rows=10, size=0.5, colors=c("#af9139", "#544616"))

}

