% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{createSccsSimulationSettings}
\alias{createSccsSimulationSettings}
\title{Create SCCS simulation settings}
\usage{
createSccsSimulationSettings(
  meanPatientTime = 4 * 365,
  sdPatientTime = 2 * 365,
  minAge = 18 * 365,
  maxAge = 65 * 365,
  minBaselineRate = 0.001,
  maxBaselineRate = 0.01,
  minCalendarTime = as.Date("2000-01-01"),
  maxCalendarTime = as.Date("2010-01-01"),
  eraIds = c(1, 2),
  patientUsages = c(0.2, 0.1),
  usageRate = c(0.01, 0.01),
  usageRateSlope = c(0, 0),
  meanPrescriptionDurations = c(14, 30),
  sdPrescriptionDurations = c(7, 14),
  simulationRiskWindows = list(createSimulationRiskWindow(relativeRisks = 1),
    createSimulationRiskWindow(relativeRisks = 1.5)),
  includeAgeEffect = TRUE,
  ageKnots = 5,
  includeSeasonality = TRUE,
  seasonKnots = 5,
  includeCalendarTimeEffect = TRUE,
  calendarTimeKnots = 5,
  calendarTimeMonotonic = FALSE,
  outcomeId = 10
)
}
\arguments{
\item{meanPatientTime}{Mean number of observation days per patient.}

\item{sdPatientTime}{Standard deviation of the observation days per patient.}

\item{minAge}{The minimum age in days.}

\item{maxAge}{The maximum age in days.}

\item{minBaselineRate}{The minimum baseline rate (per day).}

\item{maxBaselineRate}{The maximum baseline rate (per day).}

\item{minCalendarTime}{The minimum date patients are to be observed.}

\item{maxCalendarTime}{The maximum date patients are to be observed.}

\item{eraIds}{The IDs for the covariates to be generated.}

\item{patientUsages}{The fraction of patients that use the drugs.}

\item{usageRate}{The rate of prescriptions per person that uses the drug.}

\item{usageRateSlope}{The change in the usage rate from one day to the next.
\code{usageRate} is the intercept at day 0}

\item{meanPrescriptionDurations}{The mean duration of a prescription, per drug.}

\item{sdPrescriptionDurations}{The standard deviation of the duration of a prescription, per
drug.}

\item{simulationRiskWindows}{One or a list of objects of type \code{SimulationRiskWindow} as
created using the \code{\link[=createSimulationRiskWindow]{createSimulationRiskWindow()}} function.
function.}

\item{includeAgeEffect}{Include an age effect for the outcome?}

\item{ageKnots}{Number of knots in the age spline.}

\item{includeSeasonality}{Include seasonality for the outcome?}

\item{seasonKnots}{Number of knots in the seasonality spline.}

\item{includeCalendarTimeEffect}{Include a calendar time effect for the outcome?}

\item{calendarTimeKnots}{Number of knots in the calendar time spline.}

\item{calendarTimeMonotonic}{Should the calender time effect be monotonic?}

\item{outcomeId}{The ID to be used for the outcome.}
}
\value{
An object of type \code{SccsSimulationSettings}.
}
\description{
Create SCCS simulation settings
}
\details{
Create an object of settings for an SCCS simulation.
}
