% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultsDataModel.R
\name{uploadResults}
\alias{uploadResults}
\title{Upload results to the database server.}
\usage{
uploadResults(
  connectionDetails,
  schema,
  zipFileName,
  forceOverWriteOfSpecifications = FALSE,
  purgeSiteDataBeforeUploading = TRUE,
  tempFolder = tempdir(),
  tablePrefix = "",
  ...
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package.}

\item{schema}{The schema on the server where the tables have been created.}

\item{zipFileName}{The name of the zip file.}

\item{forceOverWriteOfSpecifications}{If TRUE, specifications of the phenotypes, cohort definitions, and analysis
will be overwritten if they already exist on the database. Only use this if these specifications
have changed since the last upload.}

\item{purgeSiteDataBeforeUploading}{If TRUE, before inserting data for a specific databaseId all the data for
that site will be dropped. This assumes the input zip file contains the full data for that
data site.}

\item{tempFolder}{A folder on the local file system where the zip files are extracted to. Will be cleaned
up when the function is finished. Can be used to specify a temp folder on a drive that
has sufficient space if the default system temp space is too limited.}

\item{tablePrefix}{(Optional)  string to insert before table names for database table names}

\item{...}{See ResultModelManager::uploadResults}
}
\description{
Requires the results data model tables have been created using the \code{\link{createResultsDataModel}} function.
}
