% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NRW.R
\name{NRW}
\alias{NRW}
\title{Naive Random Walk Network Estimation}
\usage{
NRW(data, type = c("num", "prop"), threshold)
}
\arguments{
\item{data}{Matrix or data frame.
A preprocessed verbal fluency matrix where
rows are participants and columns are verbal fluency
responses}

\item{type}{Character.
Type of \code{threshold} to apply.
\itemize{

\item{\code{"num"}}
{Minimum number of co-occurrences}

\item{\code{"prop"}}
{Minimum proportion of co-occurrences}

}
Defaults to \code{"nodes"}}

\item{threshold}{Numeric.
Value of the minimum number or proportion of co-occurrences.
Defaults to \code{3} for \code{"num"} and \code{.05} for \code{"prop"}}
}
\value{
Returns a undirected semantic network
}
\description{
Estimates a semantic network using the Naive Random Walk
method described in Lerner, Ogrocki, and Thomas (2009)
}
\examples{
# Get data
data <- open.clean

# Organize group data
## Get group data
group <- open.group

## Low and high openness to experience groups
low <- data[which(group == "Low"),]
high <- data[which(group == "High"),]

# Compute networks
low.net <- NRW(low)
high.net <- NRW(high)

}
\references{
Lerner, A. J., Ogrocki, P. K., & Thomas, P. J. (2009).
Network graph analysis of category fluency testing.
\emph{Cognitive and Behavioral Neurology}, \emph{22}, 45-52.
\href{https://doi.org/10.1097/WNN.0b013e318192ccaf}{https://doi.org/10.1097/WNN.0b013e318192ccaf}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
