% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASPL.R
\name{ASPL}
\alias{ASPL}
\title{Average Shortest Path Length}
\usage{
ASPL(A, weighted = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to \code{FALSE}.
Set to \code{TRUE} for weighted measures}
}
\value{
Returns the ASPL of the network
}
\description{
Computes the global average shortest path length of the network
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(similarity(sim.fluency(100), method = "cor"))

# Unweighted
aspl <- ASPL(A)

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{NeuroImage}, \emph{52}, 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
