% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCytoscapeVizMap.R
\name{createCytoscapeVizMap}
\alias{createCytoscapeVizMap}
\title{Create a Cytoscape visual style for one or more SetRank networks.}
\usage{
createCytoscapeVizMap(network = NULL, networkList = NULL,
  outputFile = "setrank.xml")
}
\arguments{
\item{network}{A single network to generate a style for.}

\item{networkList}{A list of networks to generate a single style for.}

\item{outputFile}{The path for the ouputfile.}
}
\value{
None. The function writes out a Cytoscape VizMap XML file as a 
side effect.
}
\description{
Generates a VizMap XML file that can be imported, together with the network
in Cytoscape, a tool for network analysis and visualization
(url{http://www.cytoscape.org}).
}
\details{
You must either pass a single network, through the \code{network} argument,
or a list of networks, through the \code{networkList} argument, to the 
function. When using the latter option, the function will generate a single
style applicable to all networks. This style allows to easily spot 
differences between different networks generated from the same dataset.

Specifying both arguments will results in an error. Networks should of 
course be generated by \code{\link[SetRank]{setRankAnalysis}} function.
}
\author{
Cedric Simillion
}

