% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{createPathwayTable}
\alias{createPathwayTable}
\title{Creates a table of all significant pathways in different conditions.}
\usage{
createPathwayTable(networkList, setCollection)
}
\arguments{
\item{networkList}{A list of SetRank networks created using the same
set collection.}

\item{setCollection}{The set collection used to perform the SetRank 
analysis.}
}
\value{
A data frame with column names being the names of the networks in
the \code{networkList} argument and the rownames gene set IDs. The cells
contain the adjusted p-values of each gene set in each network. When a gene 
set is not present in a network, the p-value will be set to 1. Two
additional columns called "\code{description}" and "\code{score}" are added.
The former is simply the description of the gene set. The latter is a score
which attempts to reflect the importance of a gene set across the difference
networks. The higher the score, the more important the network. This score
is a combination of the number of networks where the gene set is observed
and the geometric mean of the p-values of that set in these networks.
}
\description{
Creates a table of all significant pathways in different conditions.
}
\author{
Cedric Simillion
}

