% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{StashIdent}
\alias{StashIdent}
\title{Set identity class information}
\usage{
StashIdent(object, save.name = "oldIdent")
}
\arguments{
\item{object}{Seurat object}

\item{save.name}{Store current object@ident under this column name in object@meta.data. Can be easily retrived with SetAllIdent}
}
\value{
A Seurat object where object@ident has been appropriately modified
}
\description{
Stashes the identity in data.info to be retrieved later. Useful if, for example, testing multiple clustering parameters
}
\examples{
head(x = pbmc_small@meta.data)
pbmc_small <- StashIdent(object = pbmc_small, save.name = 'cluster.ident')
head(x = pbmc_small@meta.data)

}
