% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction.R
\name{RunICA}
\alias{RunICA}
\title{Run Independent Component Analysis on gene expression}
\usage{
RunICA(object, ic.genes = NULL, ics.compute = 50, use.imputed = FALSE,
  rev.ica = FALSE, print.results = TRUE, ics.print = 1:5,
  genes.print = 50, ica.function = "icafast", seed.use = 1,
  reduction.name = "ica", reduction.key = "IC", ...)
}
\arguments{
\item{object}{Seurat object}

\item{ic.genes}{Genes to use as input for ICA. Default is object@var.genes}

\item{ics.compute}{Number of ICs to compute}

\item{use.imputed}{Run ICA on imputed values (FALSE by default)}

\item{rev.ica}{By default, computes the dimensional reduction on the cell x
gene matrix. Setting to true will compute it on the transpose (gene x cell
matrix).}

\item{print.results}{Print the top genes associated with each dimension}

\item{ics.print}{ICs to print genes for}

\item{genes.print}{Number of genes to print for each IC}

\item{ica.function}{ICA function from ica package to run (options: icafast,
icaimax, icajade)}

\item{seed.use}{Random seed to use for fastica}

\item{reduction.name}{dimensional reduction name, specifies the position in the object$dr list. ica by default}

\item{reduction.key}{dimensional reduction key, specifies the string before the number for the dimension names. IC by default}

\item{\dots}{Additional arguments to be passed to fastica}
}
\value{
Returns Seurat object with an ICA calculation stored in
object@dr$ica
}
\description{
Run fastica algorithm from the ica package for ICA dimensionality reduction.
For details about stored ICA calculation parameters, see
\code{PrintICAParams}.
}
\examples{
pbmc_small
# Run ICA on variable genes (default)
pbmc_small <- RunICA(pbmc_small, ics.compute=5)
# Run ICA on different gene set (in this case all genes)
pbmc_small <- RunICA(pbmc_small, ic.genes = rownames(pbmc_small@data))
# Plot results
ICAPlot(pbmc_small)

}
