% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{TopFeatures}
\alias{TopFeatures}
\title{Find features with highest scores for a given dimensional reduction technique}
\usage{
TopFeatures(
  object,
  dim = 1,
  nfeatures = 20,
  projected = FALSE,
  balanced = FALSE,
  ...
)
}
\arguments{
\item{object}{DimReduc object}

\item{dim}{Dimension to use}

\item{nfeatures}{Number of features to return}

\item{projected}{Use the projected feature loadings}

\item{balanced}{Return an equal number of features with both + and - scores.}

\item{...}{Extra parameters passed to \code{\link{Loadings}}}
}
\value{
Returns a vector of features
}
\description{
Return a list of features with the strongest contribution to a set of components
}
\examples{
pbmc_small
TopFeatures(object = pbmc_small[["pca"]], dim = 1)
# After projection:
TopFeatures(object = pbmc_small[["pca"]], dim = 1,  projected = TRUE)

}
