% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/seurat.R, R/assay.R
\name{AssayData}
\alias{AssayData}
\alias{GetAssayData}
\alias{SetAssayData}
\alias{GetAssayData.Seurat}
\alias{SetAssayData.Seurat}
\alias{GetAssayData.Assay}
\alias{SetAssayData.Assay}
\title{Get and Set Assay Data}
\usage{
GetAssayData(object, ...)

SetAssayData(object, layer, new.data, slot = deprecated(), ...)

\method{GetAssayData}{Seurat}(object, assay = NULL, layer = NULL, slot = deprecated(), ...)

\method{SetAssayData}{Seurat}(
  object,
  layer = "data",
  new.data,
  slot = deprecated(),
  assay = NULL,
  ...
)

\method{GetAssayData}{Assay}(
  object,
  layer = c("data", "scale.data", "counts"),
  slot = deprecated(),
  ...
)

\method{SetAssayData}{Assay}(
  object,
  layer = c("data", "scale.data", "counts"),
  new.data,
  slot = deprecated(),
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{layer}{Name of layer to get or set}

\item{new.data}{New assay data to add}

\item{slot}{\Sexpr[stage=build,results=rd]{lifecycle::badge("deprecated")} Specific assay data to get or set}

\item{assay}{Specific assay to get data from or set data for;
defaults to the \link[=DefaultAssay]{default assay}}
}
\value{
\code{GetAssayData}: returns the specified assay data

\code{SetAssayData}: \code{object} with the assay data set
}
\description{
General accessor and setter functions for \code{\link{Assay}} objects.
\code{GetAssayData} can be used to pull information from any of the
expression matrices (eg. \dQuote{counts}, \dQuote{data}, or
\dQuote{scale.data}). \code{SetAssayData} can be used to replace one of these
expression matrices
}
\section{Lifecycle}{


\Sexpr[stage=build,results=rd]{lifecycle::badge("superseded")}



\code{GetAssayData} and \code{SetAssayData} have been superseded. To fetch
expression matrices, use \code{\link{LayerData}}; to set expression data,
use \code{\link{LayerData<-}}
}

\examples{
# Get assay data from the default assay in a Seurat object
GetAssayData(object = pbmc_small, slot = "data")[1:5,1:5]

# Set an Assay layer through the Seurat object
count.data <- GetAssayData(object = pbmc_small[["RNA"]], layer = "counts")
count.data <- as.matrix(x = count.data + 1)
new.seurat.object <- SetAssayData(
    object = pbmc_small,
    layer = "counts",
    new.data = count.data,
    assay = "RNA"
)

# Get the data directly from an Assay object
GetAssayData(pbmc_small[["RNA"]], layer = "data")[1:5,1:5]

# Set an Assay layer directly
count.data <- GetAssayData(pbmc_small[["RNA"]], layer = "counts")
count.data <- as.matrix(x = count.data + 1)
new.assay <- SetAssayData(pbmc_small[["RNA"]], layer = "counts", new.data = count.data)

}
\concept{data-access}
